<?php

namespace Drupal\Tests\posthog_js\FunctionalJavascript;

use Drupal\Core\Cache\Cache;
use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Tests posthog_js Javascript related functionalities.
 *
 * @group posthog_js
 */
class PosthogJsFunctionalJavascriptTest extends WebDriverTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * A authenticated user.
   *
   * @var \Drupal\user\Entity\User
   */
  protected $user;

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'test_page_test',
    'posthog',
    'posthog_js',
  ];

  /**
   * Clears the backend caches and rebuilds the kernel container.
   */
  public function clearBackendCaches() {
    foreach (Cache::getBins() as $cache_backend) {
      $cache_backend->deleteAll();
    }
    \Drupal::service('kernel')->rebuildContainer();
  }

  /**
   * {@inheritDoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->user = $this->drupalCreateUser([]);
    // Set google_analytics settings:
    $this->config('posthog.settings')
      ->set('host', 'https://eu.i.posthog.com')
      ->set('api_key', 'phc_XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX')
      ->save();
    $this->config('posthog_js.settings')
      ->set('enabled', TRUE)
      ->set('cdn', TRUE)
      ->save();
    $this->clearBackendCaches();
  }

  /**
   * Tests, that the session id is not reset on different page calls.
   *
   * @see https://www.drupal.org/project/posthog/issues/3506122
   */
  public function testSessionIdNotReset() {
    $driver = $this->getSession()->getDriver();

    // Go to the first page:
    $this->drupalGet('/test-page');
    // Create the session id script and get the session id:
    $sessionIdScript = "window.posthog.get_session_id()";
    $originalSessionId = $driver->evaluateScript($sessionIdScript);

    // The session id should be the same on every page:
    $this->drupalGet('/test-render-title');
    $sessionId = $driver->evaluateScript($sessionIdScript);
    $this->assertEquals($originalSessionId, $sessionId);

    $this->drupalGet('/test-page-static-title');
    $sessionId = $driver->evaluateScript($sessionIdScript);
    $this->assertEquals($originalSessionId, $sessionId);

    // We expect persistence to be localStorage+cookie by default:
    $persistenceScript = "window.posthog.config.persistence";
    $persistence = $this->getSession()->getDriver()->evaluateScript($persistenceScript);
    $this->assertEquals('localStorage+cookie', $persistence);
  }

}
