<?php

declare(strict_types=1);

namespace Drupal\posthog_php\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Posthog settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'posthog_php_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['posthog_php.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('posthog_php.settings');

    $form['enable_logging'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable logging'),
      '#default_value' => $config->get('enable_logging'),
      '#description' => $this->t('Enabling this option will log all failed Posthog PHP SDK calls to the Drupal log.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('posthog_php.settings')
      ->set('enable_logging', $form_state->getValue('enable_logging'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
