<?php

declare (strict_types=1);

namespace Drupal\postoffice_compat\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Theme hook implementations for Postoffice Compat.
 */
final class ThemeHooks {

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme(): array {
    $theme = [];

    // User plugin.
    $theme['postoffice_compat_email_user'] = [
      'variables' => [
        'body' => '',
        'email' => NULL,
        'key' => '',
        'langcode' => '',
      ],
    ];

    // Contact plugin.
    $theme['postoffice_compat_email_contact_autoreply'] = [
      'variables' => [
        'body' => '',
        'contact_form_id' => '',
        'email' => NULL,
        'key' => '',
        'langcode' => '',
      ],
    ];

    $theme['postoffice_compat_email_contact_page'] = [
      'variables' => [
        'message' => [],
        'contact_form_id' => '',
        'copy' => FALSE,
        'email' => NULL,
        'key' => '',
        'langcode' => '',
      ],
    ];
    $theme['postoffice_compat_email_contact_personal'] = [
      'variables' => [
        'message' => [],
        'copy' => FALSE,
        'email' => NULL,
        'langcode' => '',
      ],
    ];

    // Fallback plugin.
    $theme['postoffice_compat_email_fallback'] = [
      'variables' => [
        'body' => '',
        'email' => NULL,
        'module' => '',
        'key' => '',
        'langcode' => '',
      ],
    ];

    // Generic reusable templates. Only use these as embeds.
    $theme['postoffice_compat_email_body_notification'] = [
      'variables' => [],
    ];
    $theme['postoffice_compat_email_body_contact'] = [
      'variables' => [],
    ];

    return $theme;
  }

  /**
   * Implements hook_theme_suggestions_HOOK() for postoffice_compat_email_user.
   */
  #[Hook('theme_suggestions_postoffice_compat_email_user')]
  public function themeSuggestionsPostofficeCompatEmailUser(array $variables): array {
    $key = $variables['key'];
    $langcode = $variables['langcode'];

    $suggestions = [];
    $suggestions[] = 'postoffice_compat_email_user__' . $langcode;
    $suggestions[] = 'postoffice_compat_email_user__' . $key;
    $suggestions[] = 'postoffice_compat_email_user__' . $key . '__' . $langcode;

    return $suggestions;
  }

  /**
   * Implements hook_theme_suggestions_HOOK() for postoffice_compat_email_contact_autoreply.
   */
  #[Hook('theme_suggestions_postoffice_compat_email_contact_autoreply')]
  public function themeSuggestionsPostofficeCompatEmailContactAutoreply(array $variables): array {
    $key = $variables['contact_form_id'];
    $langcode = $variables['langcode'];

    $suggestions = [];
    $suggestions[] = 'postoffice_compat_email_contact_autoreply__' . $langcode;
    $suggestions[] = 'postoffice_compat_email_contact_autoreply__' . $key;
    $suggestions[] = 'postoffice_compat_email_contact_autoreply__' . $key . '__' . $langcode;

    return $suggestions;
  }

  /**
   * Implements hook_theme_suggestions_HOOK() for postoffice_compat_email_contact_page.
   */
  #[Hook('theme_suggestions_postoffice_compat_email_contact_page')]
  public function themeSuggestionsPostofficeCompatEmailContactPage(array $variables): array {
    $key = $variables['contact_form_id'];
    $langcode = $variables['langcode'];

    $suggestions = [];
    $suggestions[] = 'postoffice_compat_email_contact_page__' . $langcode;
    $suggestions[] = 'postoffice_compat_email_contact_page__' . $key;
    $suggestions[] = 'postoffice_compat_email_contact_page__' . $key . '__' . $langcode;

    return $suggestions;
  }

  /**
   * Implements hook_theme_suggestions_HOOK() for postoffice_compat_email_contact_personal.
   */
  #[Hook('theme_suggestions_postoffice_compat_email_contact_personal')]
  public function themeSuggestionsPostofficeCompatEmailContactPersonal(array $variables): array {
    $langcode = $variables['langcode'];

    $suggestions = [];
    $suggestions[] = 'postoffice_compat_email_contact_personal__' . $langcode;

    return $suggestions;
  }

  /**
   * Implements hook_theme_suggestions_HOOK() for postoffice_compat_email_fallback.
   */
  #[Hook('theme_suggestions_postoffice_compat_email_fallback')]
  public function themeSuggestionsPostofficeCompatEmailFallback(array $variables): array {
    $module = $variables['module'];
    $key = $variables['key'];
    $langcode = $variables['langcode'];

    $suggestions = [];
    $suggestions[] = 'postoffice_compat_email_fallback__' . $langcode;
    $suggestions[] = 'postoffice_compat_email_fallback__' . $module;
    $suggestions[] = 'postoffice_compat_email_fallback__' . $module . '__' . $langcode;
    $suggestions[] = 'postoffice_compat_email_fallback__' . $module . '__' . $key;
    $suggestions[] = 'postoffice_compat_email_fallback__' . $module . '__' . $key . '__' . $langcode;

    return $suggestions;
  }

}
