<?php

/**
 * @file
 * Contains prehome.page.inc.
 *
 * Page callback for Prehome entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Prehome templates.
 *
 * Default template: prehome.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_prehome(array &$variables) {
  // Fetch Prehome Entity Object.
  $prehome = $variables['elements']['#prehome'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
