/**
 * @file
 * Provides modal feature.
 *
 * The extra line between the end of the @file docblock
 * and the file-closure is important.
 */
(function (Drupal, drupalSettings, cookies) {
  /**
   * Displays the prehome in a modal.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Opens the modal.
   */
  Drupal.behaviors.prehomeModal = {
    /**
     * Attach behaviors.
     *
     * @param context
     *   This is the dom element of context.
     */
    attach(context) {
      once('prehome-modal', '#prehome-modal', context).forEach(
        function (element) {
          let displayCount = parseInt(cookies.get('prehome_display_count'), 10);
          displayCount = !Number.isInteger(displayCount) ? 0 : displayCount;
          const nbTimesToShow = parseInt(drupalSettings.times_to_show, 10)
            ? parseInt(drupalSettings.times_to_show, 10)
            : 0;

          if (displayCount < nbTimesToShow || nbTimesToShow === 0) {
            // Display modal.
            Drupal.dialog(element, {
              title: drupalSettings.title,
              classes: {
                'ui-dialog': drupalSettings.classes,
              },
              draggable: false,
              open(event, ui) {
                this.parentNode.focus();
                // Close modal on overlay click.
                document.addEventListener('click', function (event) {
                  if (
                    event.target.closest('.prehome .ui-widget-content') === null
                  ) {
                    // Prevent modal close on "protected" element.
                    const dontCloseClass = drupalSettings.dont_close_class;
                    if (
                      dontCloseClass !== '' &&
                      event.target.closest(`.${dontCloseClass}`) !== null
                    ) {
                      return;
                    }
                    // Close modal.
                    const closeButton = document.getElementsByClassName(
                      'ui-dialog-titlebar-close',
                    );
                    if (closeButton.length) {
                      closeButton[0].click();
                    }
                  }
                });
                // Increment display count.
                cookies.set('prehome_display_count', displayCount + 1, {
                  path: '/',
                  secure: true,
                });
              },
            }).showModal();
          }
        },
      );
    },
  };
})(Drupal, drupalSettings, window.Cookies);
