<?php

namespace Drupal\primary_entity_reference\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Field\Plugin\Field\FieldFormatter\EntityReferenceIdFormatter;

/**
 * Plugin implementation of the 'entity reference ID' formatter.
 */
#[FieldFormatter(
  id: 'primary_entity_reference_entity_id',
  label: new TranslatableMarkup('Entity ID'),
  description: new TranslatableMarkup('Display the ID of the referenced entities.'),
  field_types: [
    'primary_entity_reference',
  ],
)]
class PrimaryEntityReferenceIdFormatter extends EntityReferenceIdFormatter {}
