<?php

namespace Drupal\primary_entity_reference\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Field\Plugin\Field\FieldWidget\EntityReferenceAutocompleteWidget;

/**
 * Plugin implementation of the 'primary_entity_reference_autocomplete' widget.
 */
#[FieldWidget(
  id: 'primary_entity_reference_autocomplete',
  label: new TranslatableMarkup('Autocomplete'),
  description: new TranslatableMarkup('An autocomplete text field.'),
  field_types: ['primary_entity_reference'],
)]
class PrimaryReferenceAutocompleteWidget extends EntityReferenceAutocompleteWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {

    $element = parent::formElement($items, $delta, $element, $form, $form_state);
    /** @var \Drupal\primary_entity_reference\Plugin\Field\FieldType\PrimaryEntityReferenceItem $item */
    $item = $items[$delta];
    $field_name = $this->fieldDefinition->getName();
    $element['primary'] = [
      '#type' => 'radio',
      '#return_value' => $delta,
      '#title' => $this->t('Primary'),
      '#default_value' => $item->get('primary')->getValue() ? $delta : NULL,
      '#attributes' => [
        'id' => $field_name . '-primary-' . $delta,
      ],
      '#parents' => [$field_name, 0, 'primary'],
    ];

    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    $values = parent::massageFormValues($values, $form, $form_state);

    $primary = 0;
    foreach ($values as $delta => $value) {
      if (isset($value['primary']) && $value['primary']) {
        $primary = (int) $value['primary'];
      }
    }

    foreach ($values as $delta => $value) {
      $values[$delta]['primary'] = 0;
      if ($value['_original_delta'] == $primary) {

        $values[$delta]['primary'] = 1;
      }
    }

    return $values;
  }

}
