<?php

namespace Drupal\Tests\primary_entity_reference\Unit\Plugin\Field\FieldType;

use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\Entity\FieldableEntityInterface;
use Drupal\primary_entity_reference\Plugin\Field\FieldType\PrimaryEntityReferenceItem;

/**
 * Unit tests for the Primary entity reference.
 *
 * @group primary_entity_reference
 * @coversDefaultClass \Drupal\primary_entity_reference\Plugin\Field\FieldType\PrimaryEntityReferenceItem
 */
class PrimaryEntityReferenceItemTest extends UnitTestCase {


  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityTypeManager;

  /**
   * The data type manager.
   *
   * @var \Drupal\Core\TypedData\TypedDataManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $dataTypeManager;

  /**
   * The entity field manager.
   *
   * @var \Drupal\Core\Entity\EntityFieldManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityFieldManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->getStringTranslationStub();
    $container->set('string_translation', $string_translation);

    $this->entityTypeManager = $this->createMock('Drupal\Core\Entity\EntityTypeManagerInterface');
    $container->set('entity_type.manager', $this->entityTypeManager);

    $this->dataTypeManager = $this->createMock('Drupal\Core\TypedData\TypedDataManagerInterface');
    $container->set('typed_data_manager', $this->dataTypeManager);

    $this->entityFieldManager = $this->createMock('Drupal\Core\Entity\EntityFieldManagerInterface');
    $container->set('entity_field.manager', $this->entityFieldManager);

    \Drupal::setContainer($container);

  }

  /**
   * Tests the property definitions.
   */
  public function testPropertyDefinitions(): void {
    $field_storage_definition = $this->createMock(FieldStorageDefinitionInterface::class);
    $field_storage_definition->expects($this->once())
      ->method('getSettings')
      ->willReturn([
        'target_type' => 'node',
        'handler' => 'default:node',
        'handler_settings' => [
          'target_bundles' => [
            'page' => 'page',
          ],
        ],
        'cardinality' => -1,
      ]);

    $target_type_info = $this->createMock('Drupal\Core\Entity\ContentEntityTypeInterface');
    $target_type_info->expects($this->once())
      ->method('hasKey')
      ->with('id')
      ->willReturn(TRUE);
    $target_type_info->expects($this->exactly(2))
      ->method('getLabel')
      ->willReturn('Content');

    $this->entityTypeManager->expects($this->once())
      ->method('getDefinition')
      ->with('node')
      ->willReturn($target_type_info);

    $this->dataTypeManager->expects($this->once())
      ->method('createDataDefinition')
      ->with('entity')
      ->willReturn($this->createMock('Drupal\Core\TypedData\DataDefinitionInterface'));

    $properties = PrimaryEntityReferenceItem::propertyDefinitions($field_storage_definition);

    $this->assertArrayHasKey('primary', $properties);
  }

  /**
   * Tests the schema method.
   */
  public function testSchema(): void {
    $field_storage_definition = $this->createMock(FieldStorageDefinitionInterface::class);
    $field_storage_definition->expects($this->once())
      ->method('getSetting')
      ->with('target_type')
      ->willReturn('node');

    $field_storage_definition->expects($this->once())
      ->method('getSettings')
      ->willReturn([
        'target_type' => 'node',
        'handler' => 'default:node',
        'handler_settings' => [
          'target_bundles' => [
            'page' => 'page',
          ],
        ],
        'cardinality' => -1,
      ]);

    $target_type_info = $this->createMock('Drupal\Core\Entity\ContentEntityTypeInterface');
    $target_type_info->expects($this->once())
      ->method('hasKey')
      ->with('id')
      ->willReturn(TRUE);
    $target_type_info->expects($this->once())
      ->method('getKey')
      ->with('id')
      ->willReturn('nid');
    $target_type_info->expects($this->exactly(2))
      ->method('getLabel')
      ->willReturn('Content');
    $target_type_info->expects($this->exactly(2))
      ->method('entityClassImplements')
      ->with(FieldableEntityInterface::class)
      ->willReturn(TRUE);

    $this->dataTypeManager->expects($this->once())
      ->method('createDataDefinition')
      ->with('entity')
      ->willReturn($this->createMock('Drupal\Core\TypedData\DataDefinitionInterface'));

    $this->entityTypeManager->expects($this->exactly(2))
      ->method('getDefinition')
      ->with('node')
      ->willReturn($target_type_info);

    $nid_field = $this->createMock('Drupal\Core\Field\FieldDefinitionInterface');
    $nid_field->expects($this->once())
      ->method('getType')
      ->willReturn('integer');
    $this->entityFieldManager->expects($this->once())
      ->method('getBaseFieldDefinitions')
      ->with('node')
      ->willReturn([
        'nid' => $nid_field,
      ]);

    $schema = PrimaryEntityReferenceItem::schema($field_storage_definition);

    $this->assertCount(2, $schema);
    $this->assertArrayHasKey('columns', $schema);
    $this->assertCount(2, $schema['columns']);
    $this->assertArrayHasKey('primary', $schema['columns']);
    $this->assertArrayHasKey('target_id', $schema['columns']);
  }

}
