<?php

namespace Drupal\primary_entity_reference\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Field\Plugin\Field\FieldFormatter\EntityReferenceEntityFormatter;

/**
 * Plugin implementation of the 'entity reference rendered entity' formatter.
 */
#[FieldFormatter(
  id: 'primary_entity_reference_entity_view',
  label: new TranslatableMarkup('Rendered entity'),
  description: new TranslatableMarkup('Render the referenced entity.'),
  field_types: [
    'primary_entity_reference',
  ],
)]
class PrimaryEntityReferenceEntityFormatter extends EntityReferenceEntityFormatter {}
