<?php

namespace Drupal\primary_entity_reference\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\Attribute\FieldFormatter;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Field\Plugin\Field\FieldFormatter\EntityReferenceLabelFormatter;

/**
 * Plugin implementation of the 'primary reference label' formatter.
 */
#[FieldFormatter(
  id: 'primary_entity_reference_label',
  label: new TranslatableMarkup('Label'),
  description: new TranslatableMarkup('Display the label of the referenced entities.'),
  field_types: [
    'primary_entity_reference',
  ],
)]
class PrimaryEntityReferenceLabelFormatter extends EntityReferenceLabelFormatter {}
