<?php

namespace Drupal\primary_entity_reference\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\Field\Plugin\Field\FieldType\EntityReferenceItem;
use Drupal\Core\Field\PreconfiguredFieldUiOptionsInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\OptionsProviderInterface;
use Drupal\Core\TypedData\DataDefinition;
use Drupal\primary_entity_reference\Plugin\Field\PrimaryEntityReferenceFieldItemList;

/**
 * Defines the 'primary_entity_reference' entity field type.
 *
 * Supported settings (below the definition's 'settings' key) are:
 * - target_type: The entity type to reference. Required.
 */
#[FieldType(
  id: "primary_entity_reference",
  label: new TranslatableMarkup("Primary entity reference"),
  description: new TranslatableMarkup("An entity reference field with one reference as primary."),
  category: "reference",
  default_widget: "primary_entity_reference_autocomplete",
  default_formatter: "primary_entity_reference_label",
  list_class: PrimaryEntityReferenceFieldItemList::class,
)]
class PrimaryEntityReferenceItem extends EntityReferenceItem implements OptionsProviderInterface, PreconfiguredFieldUiOptionsInterface {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition) {
    $properties = parent::propertyDefinitions($field_definition);

    $properties['primary'] = DataDefinition::create('boolean')
      ->setLabel(t('Primary'));

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition) {
    $schema = parent::schema($field_definition);
    $schema['columns']['primary'] = [
      'type' => 'int',
      'size' => 'tiny',
    ];

    return $schema;
  }

  /**
   * {@inheritdoc}
   */
  public static function generateSampleValue(FieldDefinitionInterface $field_definition) {
    $values = parent::generateSampleValue($field_definition);

    $values['primary'] = (bool) mt_rand(0, 1);

    return $values;
  }

}
