<?php

declare(strict_types=1);

namespace Drupal\primary_entity_reference\Plugin\Field;

use Drupal\Core\Field\EntityReferenceFieldItemList;
use Drupal\Core\Field\EntityReferenceFieldItemListInterface;

/**
 * Defines an item list class for entity reference fields.
 */
class PrimaryEntityReferenceFieldItemList extends EntityReferenceFieldItemList implements EntityReferenceFieldItemListInterface {

  /**
   * Magic method to get the primary item.
   */
  public function __get($name) {
    // This enables $item->primary to call $this->primary()
    if ($name === 'primary') {
      return $this->primary();
    }

    // Fallback to parent for other dynamic properties.
    return parent::__get($name);
  }

  /**
   * {@inheritdoc}
   */
  public function preSave() {
    usort($this->list, function ($a, $b) {
      return $b->get('primary')->getValue() <=> $a->get('primary')->getValue();
    });

    parent::preSave();
  }

  /**
   * Gets the primary item, or the first item if none marked.
   *
   * @return \Drupal\Core\Field\FieldItemInterface|null
   *   The primary item, or NULL if none exist.
   */
  public function primary() {
    foreach ($this->list as $item) {
      if ($item->get('primary')->getValue()) {
        return $item;
      }
    }
    // Fallback to first item.
    return $this->list[0] ?? NULL;
  }

}
