# Primary Entity Reference

A Drupal module that extends entity reference fields to include primary selection functionality.

## Features

- **Primary Entity Reference Field Type**: Extends the standard entity reference field with a primary flag
- **Multiple Widget Types**:
  - Autocomplete widget with primary selection
  - Options buttons widget with primary selection
  - **Inline form widget** with primary selection (new!)
- **Multiple Formatters**: Display primary entities with different formatting options
- **Field Item List**: Custom field item list that provides easy access to the primary item

## Widgets

### Autocomplete Widget
Allows users to search for and select entities with a radio button to designate the primary reference.

### Options Buttons Widget
Provides checkboxes for multiple selection with radio buttons for primary designation.

### Inline Form Widget
**NEW!** Extends the Inline Entity Form module to allow creating and editing referenced entities inline while providing primary selection functionality.

**Features of the Inline Form Widget:**
- Create new entities directly within the form
- Edit existing entities inline
- Designate one entity as primary using radio buttons
- Visual feedback with CSS highlighting
- Form validation to ensure primary selection
- Dynamic updates when entities are added/removed

## Installation

1. Install the module via Composer:
   ```bash
   composer require drupal/primary_entity_reference
   ```

2. Enable the module:
   ```bash
   drush en primary_entity_reference
   ```

3. For the inline form widget, ensure the `inline_entity_form` module is also installed:
   ```bash
   composer require drupal/inline_entity_form
   drush en inline_entity_form
   ```

## Usage

1. Add a field to your content type
2. Select 'Primary entity reference' as the field type
3. Choose your preferred widget:
   - **Autocomplete**: For simple entity selection
   - **Options buttons**: For multiple selection scenarios
   - **Inline form**: For creating/editing entities inline
4. Configure the field settings and save
