<?php

declare(strict_types=1);

namespace Drupal\primary_entity_reference\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Field formatter hook implementations for primary_entity_reference.
 */
class PrimaryEntityReferenceFormatterHooks {

  /**
   * Implements hook_field_formatter_info_alter().
   */
  #[Hook('field_formatter_info_alter')]
  public function fieldFormatterInfoAlter(array &$info): void {
    foreach ($info as $key => $formatter_info) {
      if (in_array('entity_reference', $formatter_info['field_types'], TRUE)) {
        $info[$key]['field_types'][] = 'primary_entity_reference';
      }
    }
  }

}
