<?php

namespace Drupal\primary_entity_reference\Plugin\Field\FieldWidget;

use Drupal\Core\Field\Attribute\FieldWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Field\Plugin\Field\FieldWidget\OptionsButtonsWidget;

/**
 * Plugin implementation of the 'options_buttons' widget.
 */
#[FieldWidget(
  id: 'primary_entity_reference_options_buttons',
  label: new TranslatableMarkup('Check boxes/radio buttons'),
  field_types: [
    'primary_entity_reference',
  ],
  multiple_values: TRUE,
)]
class PrimaryEntityReferenceOptionsButtonsWidget extends OptionsButtonsWidget {

  /**
   * {@inheritdoc}
   */
  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $el = parent::formElement($items, $delta, $element, $form, $form_state);
    // Alter the checkboxes to include a radio per option.
    $values = $items->getValue();
    $options = $this->getOptions($items->getEntity());
    $default_values = array_column($values, 'target_id');

    $primary = $default_values[0] ?? NULL;

    $field_name = $this->fieldDefinition->getName();
    $elements['#type'] = 'container';
    $elements['#tree'] = TRUE;

    foreach ($options as $key => $label) {
      $elements[$key] = [
        '#type' => 'container',
        '#attributes' => ['class' => ['checkbox-radio-pair']],
        'primary' => [
          '#type' => 'radio',
          '#title' => '',
          '#return_value' => $key,
          '#parents' => [$field_name, 0, 'primary'],
          '#default_value' => ($key == $primary) ? $key : 0,
          '#attributes' => [
            'style' => 'margin-right: 35px;',
          ],
        ],
        'target_id' => [
          '#type' => 'checkbox',
          '#title' => $label,
          "#key_column" => "target_id",
          '#return_value' => $key,
          '#default_value' => in_array($key, $default_values) ? $key : 0,
        ],

      ];
    }

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    $values = parent::massageFormValues($values, $form, $form_state);
    $primary = 0;
    foreach ($values as $delta => $value) {
      if (isset($value['primary']) && $value['primary']) {
        $primary = (int) $value['primary'];
      }
    }

    $vals = [];
    $i = 0;
    foreach ($values as $value) {
      if (isset($value['primary']) && $value['primary']) {
        continue;
      }
      $vals[$i]['target_id'] = $value['target_id'];
      $vals[$i]['primary'] = 0;
      if ($value['target_id'] == $primary) {
        $vals[$i]['primary'] = 1;
      }

      $i += 1;
    }

    return $vals;
  }

}
