<?php

declare(strict_types=1);

namespace Drupal\Tests\primary_entity_reference\Unit\Hook;

use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\field\FieldStorageConfigInterface;
use Drupal\primary_entity_reference\Hook\PrimaryEntityReferenceViewsHooks;
use Drupal\Tests\UnitTestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

/**
 * Unit tests for PrimaryEntityReferenceViewsHooks.
 *
 * @group primary_entity_reference
 * @coversDefaultClass \Drupal\primary_entity_reference\Hook\PrimaryEntityReferenceViewsHooks
 */
class PrimaryEntityReferenceViewsHooksTest extends UnitTestCase {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityTypeManager;

  /**
   * The entity field manager.
   *
   * @var \Drupal\Core\Entity\EntityFieldManagerInterface|\PHPUnit\Framework\MockObject\MockObject
   */
  protected $entityFieldManager;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $container = new ContainerBuilder();

    $string_translation = $this->getStringTranslationStub();
    $container->set('string_translation', $string_translation);

    $this->entityTypeManager = $this->createMock(EntityTypeManagerInterface::class);
    $container->set('entity_type.manager', $this->entityTypeManager);

    $this->entityFieldManager = $this->createMock(EntityFieldManagerInterface::class);
    $container->set('entity_field.manager', $this->entityFieldManager);

    \Drupal::setContainer($container);
  }

  /**
   * Tests constructor with null fieldViewsDataProvider.
   *
   * @covers ::__construct
   */
  public function testConstructorWithNullFieldViewsDataProvider(): void {
    $hooks = new PrimaryEntityReferenceViewsHooks(
      $this->entityTypeManager,
      $this->entityFieldManager,
      NULL
    );

    $this->assertInstanceOf(PrimaryEntityReferenceViewsHooks::class, $hooks);
  }

  /**
   * Tests fieldViewsDataViewsDataAlter is callable.
   *
   * @covers ::fieldViewsDataViewsDataAlter
   */
  public function testFieldViewsDataViewsDataAlter(): void {
    $hooks = new PrimaryEntityReferenceViewsHooks(
      $this->entityTypeManager,
      $this->entityFieldManager,
      NULL
    );

    $data = [];
    $field_storage = $this->createMock(FieldStorageConfigInterface::class);

    // Should not throw - method is empty but implemented for completeness.
    $hooks->fieldViewsDataViewsDataAlter($data, $field_storage);

    $this->assertTrue(TRUE);
  }

}
