<?php

declare(strict_types=1);

namespace Drupal\privacy_log\Hook;

use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Database\Connection;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Performs periodic actions.
 */
class Cron {

  /**
   * Constructs a new Cron hook provider.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   *   The config factory.
   * @param \Drupal\Core\Database\Connection $database
   *   The database connection.
   * @param \Drupal\Component\Datetime\TimeInterface $time
   *   The time service.
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
    protected Connection $database,
    protected TimeInterface $time,
  ) {
  }

  /**
   * Performs periodic actions.
   *
   * @see hook_cron()
   * @see privacy_log_cron()
   */
  #[Hook('cron')]
  public function run(): void {
    if (!$this->database->schema()->tableExists('watchdog')) {
      return;
    }

    $request_time = $this->time->getRequestTime();
    $expiry = (int) ($this->configFactory->get('privacy_log.settings')
      ->get('dblog_expiry') ?? 168);
    if ($expiry > 0) {
      $lower_bound = $request_time - ($expiry * 60 * 60);
      $this->database->delete('watchdog')
        ->condition('timestamp', $lower_bound, '<')
        ->execute();
    }
  }

}
