<?php

declare(strict_types=1);

namespace Drupal\privacy_log;

use Drupal\Core\DependencyInjection\DependencySerializationTrait;
use Drupal\Core\Logger\RfcLoggerTrait;
use Psr\Log\LoggerInterface;

/**
 * Defines a privacy protecting logger.
 */
class PrivacyProtectingLogger implements LoggerInterface {
  use RfcLoggerTrait;
  use DependencySerializationTrait;

  /**
   * The logger channel.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected LoggerInterface $logger;

  /**
   * Constructs a new PrivacyProtectingLogger.
   *
   * @param \Psr\Log\LoggerInterface $logger
   *   The logger channel.
   */
  public function __construct(LoggerInterface $logger) {
    $this->logger = $logger;
  }

  /**
   * {@inheritdoc}
   *
   * @phpstan-param string|\Stringable $message
   */
  public function log($level, $message, array $context = []): void {
    $context['ip'] = '';
    $this->logger->log($level, $message, $context);
  }

}
