<?php

declare(strict_types=1);

namespace Drupal\privacy_log;

use Drupal\Core\Logger\LoggerChannelFactory;
use Psr\Log\LoggerInterface;

/**
 * {@inheritdoc}
 */
class PrivacyProtectingLoggerChannelFactory extends LoggerChannelFactory {

  /**
   * {@inheritdoc}
   */
  public function addLogger(LoggerInterface $logger, $priority = 0): void {
    $logger = new PrivacyProtectingLogger($logger);
    parent::addLogger($logger, $priority);
  }

}
