<?php

declare(strict_types=1);

namespace Drupal\Tests\privacy_log\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Verifies settings for database log module are available.
 *
 * @group privacy_log
 */
class DbLogTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'dblog',
    'privacy_log',
  ];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * Tests integration with database log module.
   */
  public function testDbLogExpirySetting(): void {
    // Verify front page is accessible.
    $this->drupalGet('');
    $this->assertSession()->statusCodeEquals(200);

    // Verify default setting in config.
    $expiry = $this->config('privacy_log.settings')->get('dblog_expiry');
    self::assertEquals($expiry, 168);

    // Create admin user.
    $admin_user = $this->drupalCreateUser([
      'administer site configuration',
      'access administration pages',
    ]);
    $this->drupalLogin($admin_user);

    // Verify expiry setting has been added to logging settings.
    $this->drupalGet('admin/config/development/logging');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Database log messages expiry');
    $this->assertSession()->pageTextContains('Maximum age of a message in the database log before it will be deleted.');

    // Verify setting can be changed.
    $edit = ['privacy_log_dblog_expiry' => 72];
    $this->submitForm($edit, 'Save configuration');
    $this->assertSession()->statusMessageContains('The configuration options have been saved.');
    $this->assertSession()->statusCodeEquals(200);

    // Verify change of setting reflected in config.
    $expiry = $this->config('privacy_log.settings')->get('dblog_expiry');
    self::assertEquals($expiry, 72);
  }

}
