/**
 * @file
 * Adds JS functionality private message flood limit type elements.
 */

(($, Drupal, once) => {
  function limitTypeWatcher(context) {
    const $elements = $(
      once('limit-type-watcher', '.pm_limit_type_select', context),
    );
    $elements.each(function limitTypeInit() {
      let type = this.value;
      const types = {};
      types.post = Drupal.t('posts');
      types.thread = Drupal.t('threads');
      $(this)
        .parents('.draggable:first')
        .find('.pm_limit_type_wrapper:first')[0].textContent = types[type];

      $(this).change(function limitTypeChange() {
        type = this.value;
        $(this)
          .parents('.draggable:first')
          .find('.pm_limit_type_wrapper:first')[0].textContent = types[type];
      });
    });
  }

  Drupal.behaviors.pmLimitTypeElement = {
    attach(context) {
      limitTypeWatcher(context);
    },
  };
})(jQuery, Drupal, once);
