<?php

declare(strict_types=1);

namespace Drupal\Tests\privatemsg\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests for the privatemsg module.
 */
class PrivatemsgNewLabelTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'privatemsg',
  ];

  /**
   * The User used for the test.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user1;

  /**
   * The User used for the test.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user2;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->user1 = $this->DrupalCreateUser([
      'privatemsg write messages',
    ]);
    \Drupal::service('user.data')->set('privatemsg', $this->user1->id(), 'enable', 1);

    $this->user2 = $this->DrupalCreateUser([
      'privatemsg write messages',
    ]);
    \Drupal::service('user.data')->set('privatemsg', $this->user2->id(), 'enable', 1);
  }

  /**
   * Tests that the message can be sent.
   */
  public function testNewLabel(): void {
    $this->drupalLogin($this->user1);
    $this->drupalGet('/messages/new');
    $this->submitForm([
      'thread_members' => $this->user2->getDisplayName() . ' (' . $this->user2->id() . ')',
      'message[0][value]' => $this->getRandomGenerator()->sentences(5),
    ], 'Send message', 'privatemsg-message-add-form');
    sleep(1);

    $this->drupalLogin($this->user2);
    // Check "new" label on "messages" page.
    $this->drupalGet('/messages');
    $cell = $this->assertSession()->elementExists('css', 'table tbody tr:nth-of-type(1) td:nth-of-type(3)');
    $this->assertSession()->elementExists('css', 'span.new', $cell);
    sleep(1);

    // Read messages.
    $this->drupalGet('/messages/view/1');
    $message = $this->assertSession()->elementExists('css',
      '.privatemsg-thread-messages .privatemsg-message:nth-of-type(1)'
    );
    $this->assertStringContainsString('privatemsg-message-unread', $message->getAttribute('class'));
    sleep(1);

    // Update the page. The message was read.
    $this->drupalGet('/messages/view/1');
    $message = $this->assertSession()->elementExists('css',
      '.privatemsg-thread-messages .privatemsg-message:nth-of-type(1)'
    );
    $this->assertStringNotContainsString('privatemsg-message-unread', $message->getAttribute('class'));
    sleep(1);

    // Send another message.
    $this->drupalLogin($this->user1);
    $this->drupalGet('/messages/view/2');
    $this->submitForm([
      'message[0][value]' => $this->getRandomGenerator()->sentences(5),
    ], 'Send message', 'privatemsg-message-add-form');
    sleep(1);

    // Check new message.
    $this->drupalLogin($this->user2);
    $this->drupalGet('/messages/view/1');
    $message = $this->assertSession()->elementExists('css',
      '.privatemsg-thread-messages .privatemsg-message:nth-of-type(2)'
    );
    $this->assertStringContainsString('privatemsg-message-unread', $message->getAttribute('class'));
    sleep(1);

    // Update the page. The message was read.
    $this->drupalGet('/messages/view/1');
    $message = $this->assertSession()->elementExists('css',
      '.privatemsg-thread-messages .privatemsg-message:nth-of-type(2)'
    );
    $this->assertStringNotContainsString('privatemsg-message-unread', $message->getAttribute('class'));
  }

}
