<?php

namespace Drupal\privatemsg\Plugin\Menu;

use Drupal\Core\Menu\MenuLinkDefault;
use Drupal\Core\Menu\StaticMenuLinkOverridesInterface;
use Drupal\privatemsg\PrivateMsgService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a implementation for menu link plugin.
 */
class PrivatemsgAccountMenuItem extends MenuLinkDefault {

  /**
   * Constructs a new PrivatemsgAccountMenuItem object.
   *
   * @param array $configuration
   *   The configuration for the menu link plugin.
   * @param string $plugin_id
   *   The plugin ID for the menu link plugin.
   * @param array $plugin_definition
   *   The definition for the menu link plugin.
   * @param \Drupal\Core\Menu\StaticMenuLinkOverridesInterface $static_override
   *   The static menu link overrides.
   * @param \Drupal\privatemsg\PrivateMsgService $privateMsgService
   *   The privatemsg.common service.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    StaticMenuLinkOverridesInterface $static_override,
    protected readonly PrivateMsgService $privateMsgService,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $static_override);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('menu_link.static.overrides'),
      $container->get('privatemsg.common'),
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getTitle() {
    $count = $this->privateMsgService->getUnreadThreadCount();
    $text = $this->t('Private Messages');
    if ($count > 0) {
      return $text . " ($count)";
    }
    return $text;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheMaxAge() {
    return 0;
  }

}
