<?php

declare(strict_types=1);

namespace Drupal\Tests\privatemsg\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests for the privatemsg module.
 */
class PrivatemsgLeaveChatTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'privatemsg',
  ];

  /**
   * The User used for the test.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user1;

  /**
   * The User used for the test.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user2;

  /**
   * The User used for the test.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user3;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->user1 = $this->DrupalCreateUser([
      'privatemsg write messages',
    ]);
    \Drupal::service('user.data')->set('privatemsg', $this->user1->id(), 'enable', 1);

    $this->user2 = $this->DrupalCreateUser([
      'privatemsg write messages',
    ]);
    \Drupal::service('user.data')->set('privatemsg', $this->user2->id(), 'enable', 1);

    $this->user3 = $this->DrupalCreateUser([
      'privatemsg write messages',
    ]);
    \Drupal::service('user.data')->set('privatemsg', $this->user3->id(), 'enable', 1);
  }

  /**
   * Tests leave chat functionality.
   */
  public function testLeaveChat(): void {
    $this->drupalLogin($this->user1);
    $this->drupalGet('/messages/new');
    $this->submitForm([
      'thread_members' => $this->user2->getDisplayName() . ' (' . $this->user2->id() . '),' . $this->user3->getDisplayName() . ' (' . $this->user3->id() . ')',
      'message[0][value]' => $this->getRandomGenerator()->sentences(5),
    ], 'Send message', 'privatemsg-message-add-form');

    $this->drupalLogin($this->user2);
    $this->drupalGet('messages/view/1');

    $threads_storage = $this->container->get('entity_type.manager')->getStorage('privatemsg_thread');

    for ($i = 1; $i <= 3; $i++) {
      $thread = $threads_storage->load($i);
      $members = $thread->getMembers();
      $this->assertCount(3, $members);
    }

    $this->clickLink('Leave chat');

    $threads_storage->resetCache([1, 2, 3]);

    for ($i = 1; $i <= 3; $i++) {
      $thread = $threads_storage->load($i);
      $members = $thread->getMembers();
      $this->assertCount(2, $members);
    }

    $this->drupalGet('messages');
    $this->assertSession()->elementTextContains('css', '.vbo-view-form', 'No messages available.');
  }

}
