<?php

declare(strict_types=1);

namespace Drupal\Tests\privatemsg\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests for the privatemsg module.
 */
class PrivatemsgReadUnreadActionTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'privatemsg',
  ];

  /**
   * The User used for the test.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user1;

  /**
   * The User used for the test.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user2;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();
    $this->user1 = $this->DrupalCreateUser([
      'privatemsg write messages',
    ]);
    \Drupal::service('user.data')->set('privatemsg', $this->user1->id(), 'enable', 1);
    $this->user2 = $this->DrupalCreateUser([
      'privatemsg write messages',
      'privatemsg use messages actions',
    ]);
    \Drupal::service('user.data')->set('privatemsg', $this->user2->id(), 'enable', 1);
  }

  /**
   * Helper function that executes en operation.
   *
   * @param string $path
   *   The path of the View page that includes VBO.
   * @param string $button_text
   *   The form submits button text.
   * @param int[] $selection
   *   The selected items' indexes.
   * @param array $data
   *   Additional parameters for the submitted form.
   */
  protected function executeAction(string $path, string $button_text, array $selection = [], array $data = []): void {
    foreach ($selection as $index) {
      $data["views_bulk_operations_bulk_form[$index]"] = TRUE;
    }
    $this->drupalGet($path);
    $this->submitForm($data, $button_text);
  }

  /**
   * Tests that the threads can be mark as read and unread.
   */
  public function testReadUnreadAction(): void {
    $this->drupalLogin($this->user2);

    $this->drupalGet('/messages/new');
    $this->submitForm([
      'thread_members' => $this->user1->getDisplayName() . ' (' . $this->user1->id() . ')',
      'message[0][value]' => $this->getRandomGenerator()->sentences(5),
    ], 'Send message', 'privatemsg-message-add-form');
    sleep(2);

    $this->drupalGet('/messages/new');
    $this->submitForm([
      'thread_members' => $this->user1->getDisplayName() . ' (' . $this->user1->id() . ')',
      'message[0][value]' => $this->getRandomGenerator()->sentences(5),
    ], 'Send message', 'privatemsg-message-add-form');
    sleep(2);

    // User 1 doesn't have permissions to use actions.
    $this->drupalLogin($this->user1);
    $selected = [0, 1];
    $data = ['action' => 1];
    // Try to mark as read.
    $this->executeAction('/messages', 'Apply to selected items', $selected, $data);
    $this->drupalGet('/messages');
    // Messages still unread.
    $this->assertSession()->elementExists('css', 'span.new');

    $this->drupalGet('/messages/new');
    $this->submitForm([
      'thread_members' => $this->user2->getDisplayName() . ' (' . $this->user2->id() . ')',
      'message[0][value]' => $this->getRandomGenerator()->sentences(5),
    ], 'Send message', 'privatemsg-message-add-form');
    sleep(2);

    $this->drupalGet('/messages/new');
    $this->submitForm([
      'thread_members' => $this->user2->getDisplayName() . ' (' . $this->user2->id() . ')',
      'message[0][value]' => $this->getRandomGenerator()->sentences(5),
    ], 'Send message', 'privatemsg-message-add-form');
    sleep(2);

    // User 2 has permissions to use actions.
    $this->drupalLogin($this->user2);
    $selected = [0, 1];
    $data = ['action' => 1];
    // Try to mark as read.
    $this->executeAction('/messages', 'Apply to selected items', $selected, $data);
    $this->drupalGet('/messages');
    // All messages have been read.
    $this->assertSession()->elementNotExists('css', 'span.new');

    $selected = [0, 1];
    $data = ['action' => 2];
    // Try to mark as unread.
    $this->executeAction('/messages', 'Apply to selected items', $selected, $data);
    $this->drupalGet('/messages');
    $this->assertSession()->elementExists('css', 'span.new');
  }

}
