<?php

namespace Drupal\privatemsg;

use Drupal\Core\Security\TrustedCallbackInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Lazy builder.
 */
class PrivateMsgLazyBuilder implements TrustedCallbackInterface {

  use StringTranslationTrait;

  /**
   * Constructs the PrivateMsgLazyBuilder object.
   */
  public function __construct(
    protected readonly privateMsgService $privateMsgService,
  ) {}

  /**
   * Render menu item title.
   */
  public function renderMenuItemTitle() {
    $count = $this->privateMsgService->getUnreadThreadCount();
    $text = $this->t('Private Messages');
    $markup = $text;
    if ($count > 0) {
      $markup = "$text ($count)";
    }
    return [
      '#markup' => $markup,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks() {
    return ['renderMenuItemTitle'];
  }

}
