# Protected Content (proc) Module

## Contents

- [Introduction](#introduction)
- [Usage on Standalone Mode](#usage-on-standalone-mode)
- [Usage on Field Mode](#usage-on-field-mode)
- [Field formatters](#field-formatters)
- [Auxiliary Paths](#auxiliary-paths)
- [API Paths](#api-paths)
- [Canonical Entity Paths](#canonical-entity-paths)
- [Global Configuration](#global-configuration)
- [Widget Configuration](#widget-configuration)
- [Installation](#installation)
- [OpenPGP.js](#openpgpjs)
- [Caveats](#caveats)
- [Future Roadmap](#future-roadmap)
- [Learn More About Protected Content](#learn-more-about-protected-content)
- [Similar Project](#similar-project)
- [Maintainers](#maintainers)

## Introduction

The Protected Content (proc) module enables client-side encryption and decryption of content. It supports two modes of usage:

- **Standalone Mode**: Provides forms to encrypt and decrypt content.
- **Field Mode**: Provides a field type to encrypt and decrypt text or files from within any fieldable form.

## Usage on Standalone Mode

- Access `/proc/generate-keys` to generate keys for the current user.
- Access `/proc/add/<uids_csv>` to encrypt a file for the users identified in `<uids_csv>` (a comma-separated list of user IDs). Protected Content will provide an exclusive access link (in the format `/proc/<proc ID>` ) for the recipients to decrypt the file.
- Access `/proc/<proc ID>/update` to re-encrypt the file for the wished set of recipients.
- Access `proc/my-update` to update the recipients of the files pending update.

## Usage on Field Mode

- Add a field of type `Proc Entity Reference Field` to any form and configure it according to your needs.

## Field formatters

The `Proc Entity Reference Field` field type provides the following formatters:

- **Label**: displays the label of the encrypted content. Options:
  - ***Link label to the referenced entity***: the link points to the entity details page.
  - ***Open in a new tab***
  - ***Switch link destination to the decrypt form***
  - ***Use decrypt modal form***
- **Armoured**: allows the embedded decryption of multimedia content (image, video, audio and text) on page load.

## Auxiliary Paths

- `/proc/key-cache-settings` allows you to configure the key cache settings. The available options are: `No cache`, `1 hour cache`, `2 hours cache`.
- `/proc/my-keys-overview` lists all keys generated by the current user.

## API Paths

- `/api/proc/getpubkey/{entity_ids}/{search_by}` returns as json the public keys identified by `{entity_ids}` (a comma-separated list of IDs). The `{search_by}` parameter can be `user_id` xor `id` (meaning, key ID).
- `/api/proc/getcipher/{cipher_ids}` returns as json the cipher texts identified by `{cipher_ids}` (a comma-separated list of IDs) or, depending on the corresponding entity, the metadata of a public key.

## Canonical Entity Paths

- `admin/content/procs` lists all protected content entities: encrypted content and keys.
- `proc/<entity ID>/details` shows the details of a protected content entity. Notably, it shows the cache type of the key and the recipients of the content.
- `proc/<entity ID>/edit` allows you to edit, in the metadata layer only, the recipients of encrypted content or the type of the protected content entity.
- `proc/<entity ID>/delete` allows you to delete a protected content entity.

## Global Configuration

A global configuration form is available at `/admin/config/system/proc`. The following global settings are available:

- Global stream wrapper
- Enable stream wrapper globally
- RSA key size
- Maximum size for encryption (in bytes)
- Block size (lines of armored cipher text)
- Enable block size limit
- Global standard label for the encrypt link
- Global label for encryption on a file field when there is a default value
- Classes for the encrypt link
- Enable local password cache for fields
- Encryption strategy
- Suppress decrypt link from the encryption success message
- Suppress the entire encryption success message
- Maximum number of files for re-encryption at My Update form
- Maximum sum size (MB) of files for re-encryption at My Update form

## Widget Configuration

Widget configurations are available when managing the form display of an entity where the `Proc Entity Reference Field` is used. The following settings are available:

- Machine name of the field containing the user IDs of recipients
- Machine name of the field containing user IDs of CC recipients
- Define the user IDs of recipients in a CSV list
- Endpoint for fetching user IDs of recipients
- Identifier of form elements to be used as parameters for the endpoint
- Label for the encrypt link
- Label for the decrypt link
- Type of identifier
- Modes of operation
- Modes of input
- Modes of decryption
- Password caching
- Trigger format
- Submit element ID for the master field
- Trigger decryption of another encrypted field
- Relabeling pattern
- Re-encryption plugin

## Plugin Types

- Proc Re-encryption Recipients Set (ProcReEncRecSet) allows the update the wished set of recipients in case business rules requires a change in the set of recipients or keys renewal.
- Proc Relabelling (ProcRelabelling) allows the relabelling of the encrypted content. This is useful for avoiding final user direct exposure of sensitive file names.

## Installation

Install as usual. OpenPGP.js v5.0.1 is shipped with the module. See the disclaimer below.

## OpenPGP.js

A copy of minified `openpgp.js` is included in the module at `js/openpgp.min.js`. It is used for encrypting and decrypting content. The version of `openpgp.js` is 5.0.1, licensed under LGPL-3.0. Source code is available at [OpenPGP.js](https://openpgpjs.org/). The minified version is available at [unpkg](https://unpkg.com/openpgp@5.0.1/dist/openpgp.min.js).

## Caveats

Proc uses a cache first strategy for handling public keys for encryption and cipher texts for decryption. It will try to download a cipher text only when the download is needed. However, in development context, if you reset the proc table you will have to clear manually your browser's cache to avoid errors when decrypting again a protected content which entity ID was already used previously.

## Future Roadmap

- Text area field encryption and decryption.
- Cryptographic signature and signature verification.
- Multiple signatures per content with recursive encryption.

## Learn More About Protected Content

- [Protected Content, Secure Open Source Day - Haarlem (2019)](https://youtu.be/rVWrkZPGj3s "Protected Content, Secure open source day - Haarlem (2019)")
- [Protected Content: End-to-End PGP Encryption for Drupal, Drupal Camp - Kyiv (2019)](https://youtu.be/Gx8uxEpi4Po "End-to-End PGP Encryption for Drupal, Drupal Camp - Kyiv (2019)")
- [Protected Content by Asymmetrical Client-Side Encryption, Drupal Dev Days - Ghent (2022)](https://drupalcamp.be/en/drupal-dev-days-2020/session/protected-content-asymmetrical-client-side-encryption "Protected Content by Asymmetrical Client-Side Encryption, Drupal Dev Days - Ghent (2022)")
- [A Pretty Good Content Protection (Workshop), DrupalCon - Prague (2022)](https://events.drupal.org/prague2022/sessions/pretty-good-content-protection-workshop "A Pretty Good Content Protection (Workshop), DrupalCon - Prague (2022)")

## Similar Project

- [Client-Side File Crypto](https://www.drupal.org/project/client_side_file_crypto "Client-Side File Crypto")

## Maintainers

- Rodrigo Panchiniak Fernandes - [Profile](https://www.drupal.org/user/411448)
- Duarte Briz (duartebriz) - [Profile](https://www.drupal.org/u/duartebriz)
- Reva Gomes (revagomes) - [Profile](https://www.drupal.org/u/revagomes)
