# Changelog

All notable changes to this project will be documented in this file.

## [10.1.92] - 13 Nov 2025

- Fixed bug on cache clearing after changing update jobs.

## [10.1.91] - 13 Nov 2025

- Fixed bug on re-encryption of several procs at once.
- Added Drush commands for management of proc entities.

## [10.1.90] - 4 Nov 2025

- Added the Proc Metadata Transitioner submodule.
- Enriched console messages. Validated recipient IDs on re-encryption.
- Added error handling for failure on fetching re-encryption recipients.

## [10.1.89] - 4 May 2025

- Added subfolders in the js directory. Added versioning to js libraries for cache invalidation.

## [10.1.88] - 30 Apr 2025

- Bug fix. Added missing check for default value of proc field in ProcFieldProcessor.

## [10.1.87] - 29 Apr 2025

- Allowed only input or select elements to be used as source of dynamic fetcher filters, identified by id or name.

## [10.1.86] - 29 Apr 2025

- Removed enforced input element on fetcher filter.

## [10.1.85] - 25 Apr 2025

- Rolled back to static entity query for backwards compatibility at userHasKeyring().

## [10.1.84] - 25 Apr 2025

- Fixed bug on getting metadata.

## [10.1.83] - 23 Apr 2025

- Added in ProcKeysCacheTypeForm a warning on leaving the browser unlocked while password cache is active.
- Added origin field name to proc metadata.
- Fixed usage of default proc id on editing content.
- Added standard re-encryption plugin.
- Moved lost access recipients into the wished set of recipients.
- Fixed comparison of dates in re-encryption plugin.
- Added missing property to ProcEntityReferenceWidget.
- Added uid as default field key when fetcher endpoint retrieves objects instead of a flat list of user IDs.
- Added accepted json formats in the description of the fetcher endpoint field settings of the proc field widget.
- Updated list of wished recipients by fetching endpoint.
- Added X-CSRF-Token for updating set of wished recipients.
- Cached response of wished recipients. Refactored proc field js init method.
- Added My Update Form.
- Added update job proc IDs to my update form.
- Added removal of expired update jobs.
- Added number of files and max size sum for re-encryption.

## [10.1.82] - 18 Feb 2025

- Added several js modules for decryption and update operations.
- Added triggerCacheDecryption js module.
- Added js modules for splitting steps of decryption.
- Added re-encryption.
- Fixed condition checking for opLink at handleDecryptionResult().
- Added console info showing proc IDs being updated and their resolved recipients.
- Submitted metadata on re-encryption.
- Fixed wrong password error message.
- Added method for checking PGP opening format.
- Added previous recipients to re-encryption success message.
- Added buildDecryptionLink method for operations in form base.
- Fixed selection of recipients on re-encryption.
- Implemented getPassSessionCachingSalt() for decryption of lists.
- Implemented messages API.
- Removed getDrupalSettings() in favor of methods covering each subset of encyrption operation settings.
- Added check of field on decryption.
- Normalized query string variable name.
- Reorganized js settings for encryption and update.
- Simplified drupalSettings definition at decryption form.
- Fixed bug in field formatter.
- Fixed cache usage on stand-alone decryption mode.
- Restored switch to text encryption library.
- Implemented generateAjaxSettings().
- Removed usage of deprecated items in navigator object.
- Issue #3474333 by abautu: Incorrect match of element by id/name. Added select selectors to the document.querySelector expressions.
- Replaced FileSystemInterface::EXISTS_REPLACE by FileExists::Rename for avoiding data loss on rare hash collisions. Issue raised by suranga.gamage.
- Replaced deprecated FormElement by FormElementBase.
- Added parent constructor to ProcKeysGenerationForm class.
- Added formatSize method into ProcForm class.
- Added ProcFieldProcessor service.
- Replaced static call to ::fromUri by new Url object.
- Replaced ::escape by renderInIsolation at ProcOpFormBase class.
- Added ProcDecAccessCheck class.
- Fixed redirection on key generation form submit. Added d.11 on info file.
- Replaced Html::escape by htmlspecialchars.
- Added unit tests for the keys generation form.
- Added unit tests for several classes.
- Added default bundle to proc entities.
- Avoided repeated items across constants.
- Fixed phrasing in the parameter of a route.
- Fixed bug on usage of proc field with default value.


## [10.1.81] - 11 Sep 2024

- Added rendering of SVG image files at armoured field formatter.

## [10.1.80] - 9 Sep 2024

- Fixed bug in absence of CC recipients by direct fetcher.
- Added decryption of multiple files in a single click.

## [10.1.79] - 23 Aug 2024

- Fixed bug on key creation.
- Added fetcher endpoint to cipher metadata.
- Required permission for encryption by anonymous user.

## [10.1.78] - 6 Aug 2024

- Fixed bug on trying to access a proc with id ZERO.

## [10.1.77] - 2 Aug 2024

- Disabled autocomplete on proc file fields for non-admin users by default.

## [10.1.76] - 1 Aug 2024

- Fixed bug on submission of existing content by users not included in the set
of recipients.

## [10.1.75] - 31 Jul 2024

- Removed the decrypt button from disabled text fields.

## [10.1.74] - 22 Jul 2024

- Removed reset button if field is disabled.

## [10.1.73] - 19 Jul 2024

- Added configuration for the label of reset button.

## [10.1.72] - 18 Jul 2024 at 20:45 CEST

- Removed yet another type declaration for backwards compatibility.

## [10.1.71] - 18 Jul 2024 at 20:39 CEST

- Removed yet another type declaration for backwards compatibility.

## [10.1.70] - 17 Jul 2024

- Fixed bug on the selection of recipients under permissive policy.

## [10.1.69] - 11 Jul 2024

- Added multimedia support on armoured formatter.
- Added original file name to download of unrecognized mime type files.
- Added temporary download link to unrecognized mime types in decryption of lists.

## [10.1.68] - 5 Jul 2024

- Added option for a reset button in single-valued proc file fields.

## [10.1.67] - 4 Jul 2024 at 13:55 CEST

- Rolled back from FormElementBase to FormElement.

## [10.1.66] - 4 Jul 2024 at 12:39 CEST

- Replaced ProcAjaxModalMsgController by directly appending a message.
- Added fall back to default label of encrypt button.
- Added autocomplete attribute on password field.
- Increased default value for maximum size of encryption.

## [10.1.65] - 18 Jun 2024

- Fixed bug on the change of a proc field label.
- Added on-the-fly decryption of default text.

## [10.1.64] - 25 May 2024

- Fixed selection of delta on proc file field widget being shown in a dialog.
