<?php

namespace Drupal\proc\Drush\Commands;

/**
 * Public Drush command contract for proc metadata transition operations.
 */
interface ProcCommandsInterface {

  /**
   * Remove wished recipients from given proc.
   *
   * @param array $options
   *   Command options.
   */
  public function removeWishedRecipients(array $options = []): void;

  /**
   * Get Update jobs from user ID.
   *
   * @param array $options
   *   Command options.
   */
  public function getUpdateJobsFromUserId(array $options = ['user_id' => NULL]): void;

}
