# Product Manager Tool

A comprehensive Drupal module for bulk management of Commerce products and variations with advanced layout template and field management capabilities.

## Overview

Product Manager Tool provides powerful bulk operations for Drupal Commerce products and variations, including:

- **Layout Template Manager**: Clone and apply Layout Builder configurations across multiple products
- **Field Manager**: Bulk update fields across products and variations with translation support
- **Multi-language Support**: Full translation support for all operations
- **Permission System**: Granular access control for all operations

## Features

### Layout Template Manager

- Create layout templates from existing products with Layout Builder enabled
- Clone layouts between products in bulk operations
- Support for template products with [TEMPLATE] prefix
- Multi-language layout management
- Block configuration preservation
- Preview and confirmation workflow
- Automatic layout validation and error handling

### Field Manager

- Bulk field updates for products and variations
- Empty field detection and reporting
- Override protection for existing values
- Translation-aware field operations
- Apply field updates to all translations or specific languages
- Field statistics and status reporting
- Support for complex field types (Entity Reference, IEF, etc.)
- Disabled field handling via Disable Field module integration

### Core Capabilities

- **Entity Selection**: Flexible selection with checkboxes and filters
- **Preview System**: Dry-run functionality to preview changes before applying
- **Translation Support**: Update multiple language versions simultaneously
- **Progress Tracking**: Detailed statistics on updates, skips, and failures
- **Access Control**: Permission-based validation for all operations
- **Error Handling**: Comprehensive error reporting and logging

## Requirements

- Drupal 10 or 11
- Commerce
- Commerce Product
- Layout Builder
- Inline Entity Form

## Installation

1. Download and extract the module to your modules directory:
   ```
   /modules/custom/product_manager_tool
   ```

2. Enable the module:
   ```
   drush en product_manager_tool
   ```

3. Configure permissions at:
   ```
   /admin/people/permissions
   ```

## Permissions

The module provides the following permissions:

- **Access Product Manager Tool**: Basic access to the tool
- **Manage Product Layouts**: Create and apply layout templates
- **Bulk Update Product Fields**: Update fields across multiple entities
- **Create Layout Templates**: Create new layout templates from products

## Usage

### Accessing the Tool

Navigate to: `/admin/commerce/product-manager-tool`

The main interface provides tabs for:
- Layout Manager
- Field Manager

### Layout Template Manager

#### Creating a Template

1. Select "Layout Manager" tab
2. Choose a product type
3. Select a template product (products with [TEMPLATE] prefix are highlighted)
4. Enter a template name and description
5. Save the template

#### Applying a Template

1. Select a saved template from the dropdown
2. Choose target products using checkboxes
3. Select language for layout application
4. Preview the changes (dry-run mode)
5. Confirm and apply

#### Template Features

- **Template Products**: Products with titles starting with [TEMPLATE] are identified as templates
- **Language Support**: Apply layouts to specific translations
- **Block Preservation**: All block configurations are maintained
- **Validation**: Automatic checks for Layout Builder compatibility
- **Preview**: See exactly which products will be updated before applying

### Field Manager

#### Bulk Field Updates

1. Select "Field Manager" tab
2. Choose entity type (Product or Variation)
3. Select product/variation type
4. Choose language/translation
5. Configure field options:
    - Include disabled fields
    - Include entities with filled fields
6. Select entities to update
7. Fill in field values
8. Configure options:
    - Override existing values
    - Apply to all translations
9. Preview changes
10. Confirm and apply

#### Field Update Features

- **Empty Field Detection**: Automatically identifies fields that need values
- **Override Control**: Choose whether to overwrite existing values per field
- **Translation Options**: Apply updates to specific or all translations
- **Field Statistics**: View how many entities have empty vs filled fields
- **Per-Language Stats**: See field status breakdown by language
- **IEF Support**: Full support for Inline Entity Form fields
- **Complex Fields**: Handles entity references, paragraphs, and more

#### Field Status Information

The Field Manager provides detailed statistics:

- Total entities selected
- Fields to be updated
- Fields to be skipped (already filled)
- Per-language breakdown of updates
- Translation-specific status

## Architecture

### Services

The module uses a service-oriented architecture:

#### FieldEntityProcessor
- Handles entity field operations
- Manages field value application
- Provides field status information
- Handles translation logic

#### FieldValueProcessor
- Processes and validates field values
- Handles complex field types
- Manages IEF entity creation
- Sanitizes input data

#### FieldTableBuilder
- Builds entity selection tables
- Generates field status displays
- Handles pagination
- Manages table rendering

#### FieldAccessValidator
- Validates user permissions
- Checks entity access
- Sanitizes user input
- Validates field values

### Form Structure

#### ProductManagerForm
Main wrapper form providing navigation between:
- Layout Template Manager
- Field Manager

#### LayoutTemplateForm
Manages layout template operations:
- Template creation
- Template management
- Layout application
- Preview and confirmation

#### ProductFieldManagerForm
Manages field bulk operations:
- Entity selection
- Field value editing
- Preview and confirmation
- Batch application

### Security

The module implements multiple security layers:

1. **Permission Checks**: All operations require appropriate permissions
2. **Entity Access Validation**: Per-entity access checks before updates
3. **Field Access Control**: Field-level permission validation
4. **Input Sanitization**: All user input is sanitized
5. **CSRF Protection**: Drupal form API security
6. **Logging**: All operations are logged for audit trails

## Configuration

### Module Settings

No additional configuration is required. The module uses Drupal's standard configuration system.

### Field Types Support

Supported field types:
- Text (plain, formatted)
- Number (integer, decimal, float)
- Entity Reference
- Boolean
- Date/Time
- List (options)
- Paragraphs
- Inline Entity Form
- And all standard Drupal field types

Excluded fields:
- System fields (UID, created, changed)
- Commerce-specific (SKU, price, list_price)
- Layout Builder internal fields
- Remote ID fields

### Disabled Field Integration

The module integrates with the Disable Field module:
- Detects disabled fields
- Optionally includes/excludes them from operations
- Marks disabled fields in the UI
- Respects field disable settings

## Translation Support

### Multi-language Features

- Select specific language for updates
- Apply changes to all translations simultaneously
- Per-language field status reporting
- Translation-aware preview
- Language-specific statistics

### Translation Workflow

1. Select primary language for operation
2. Choose fields to apply across all translations
3. Preview shows which translations will be updated
4. Confirmation displays per-language statistics
5. Updates maintain translation integrity

## Best Practices

### Layout Templates

1. **Use Template Products**: Create products specifically as templates with [TEMPLATE] prefix
2. **Test First**: Always use preview mode before applying to production
3. **Backup Layouts**: Consider backing up important layouts before bulk changes
4. **Language Planning**: Plan which translations need layout updates

### Field Updates

1. **Start Small**: Test with a few entities before bulk operations
2. **Use Filters**: Filter by empty fields to avoid unnecessary updates
3. **Check Override**: Only enable override when you need to replace existing values
4. **Review Statistics**: Check the preview statistics before confirming
5. **Translation Strategy**: Decide per-field if updates should apply to all languages

### Performance

1. **Batch Size**: Select reasonable numbers of entities (100-500 recommended)
2. **Complex Fields**: Be aware that complex fields (IEF, Paragraphs) take longer
3. **Translations**: Updating all translations increases processing time
4. **Monitor**: Check Drupal logs for any performance issues

## Troubleshooting

### Common Issues

**AJAX Errors**
- Clear Drupal cache
- Check PHP memory limit
- Verify module dependencies

**Permission Denied**
- Verify user has required permissions
- Check entity-level access
- Review field permissions

**Layout Not Applying**
- Ensure Layout Builder is enabled on product type
- Verify template product has a valid layout
- Check for layout conflicts

**Fields Not Updating**
- Verify field exists on target entities
- Check field is not disabled (unless intentionally included)
- Ensure override is enabled if replacing existing values

### Debugging

Enable verbose logging:
```php
$config['system.logging']['error_level'] = 'verbose';
```

Check logs at: `/admin/reports/dblog`

Search for: `product_manager_tool`

## Development

### Extending the Module

The module is designed for extensibility:

#### Adding Custom Field Processors

```php
namespace Drupal\my_module\Plugin\FieldProcessor;

use Drupal\product_manager_tool\Service\FieldValueProcessor;

class CustomFieldProcessor extends FieldValueProcessor {
  // Custom field processing logic
}
```

#### Adding Custom Validators

```php
namespace Drupal\my_module\Plugin\FieldValidator;

use Drupal\product_manager_tool\Service\FieldAccessValidator;

class CustomValidator extends FieldAccessValidator {
  // Custom validation logic
}
```

### Hooks

The module respects standard Drupal hooks:
- `hook_entity_presave()`
- `hook_entity_update()`
- `hook_form_alter()`

### Testing

Recommended testing approach:
1. Create test products/variations
2. Test with template products first
3. Verify translations work correctly
4. Test permission restrictions
5. Validate all field types

## Performance Considerations

### Optimization Tips

1. **Database**: Ensure proper indexing on product/variation tables
2. **Caching**: The module respects Drupal cache
3. **Batch Processing**: Large operations are handled efficiently
4. **Memory**: Increase PHP memory for large bulk operations

### Recommended Limits

- Products per operation: 500-1000
- Fields per update: No hard limit (depends on complexity)
- Translations: All supported, but impacts performance

## Support

### Resources

- Module Issue Queue: [Project page]
- Documentation: This README
- Drupal.org: Search for "Product Manager Tool"

### Reporting Issues

When reporting issues, include:
1. Drupal version
2. Module version
3. Steps to reproduce
4. Error messages from logs
5. Expected vs actual behavior

## Changelog

### Version 1.0.1

- Initial release
- Layout Template Manager
- Field Manager with translation support
- Permission system
- Security hardening
- Comprehensive error handling

## License

GPL-2.0-or-later

## Author

Product Manager Tool development

## Credits

Built with:
- Drupal Commerce
- Layout Builder
- Inline Entity Form

Special thanks to the Drupal Commerce and Layout Builder communities.