/* phpcs:ignoreFile */
/**
 * @file
 * Handles confirmation button countdowns.
 */

(function (Drupal, once) {
  'use strict';

  Drupal.behaviors.confirmCountdown = {
    attach: function (context, settings) {
      once('confirm-countdown', '.confirm-countdown-button', context).forEach(function (button) {
        let countdown = 3;
        const originalText = button.value;
        button.disabled = true;
        button.value = originalText + ' (' + countdown + ')';

        const interval = setInterval(function () {
          countdown--;
          if (countdown > 0) {
            button.value = originalText + ' (' + countdown + ')';
          } else {
            button.value = originalText;
            button.disabled = false;
            clearInterval(interval);
          }
        }, 1000);
      });
    }
  };

})(Drupal, once);
