/* phpcs:ignoreFile */
/**
 * @file
 * Handles scroll top.
 */

(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.productManagerScroll = {
    attach: function (context, settings) {
      const elems = once('productManagerScroll', '.product-field-update, .messages--error', context);
      if (elems.length) {
        setTimeout(function () {
          window.scrollTo({
            top: 0,
            behavior: 'smooth'
          });
        }, 100);
      }
    }
  };
})(jQuery, Drupal, once);
