/* phpcs:ignoreFile */
/**
 * @file
 * Handles Select All / Deselect All checkbox actions.
 */

(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.productManagerSelectBoxes = {
    attach(context, settings) {

      // Select All button.
      once('product-select-all', '#product-select-all', context).forEach(button => {
        $(button).on('click', e => {
          e.preventDefault();
          $('.entity-checkbox', context).prop('checked', true);
        });
      });

      // Deselect All button.
      once('product-deselect-all', '#product-deselect-all', context).forEach(button => {
        $(button).on('click', e => {
          e.preventDefault();
          $('.entity-checkbox', context).prop('checked', false);
        });
      });

    }
  };

})(jQuery, Drupal, once);
