(function (Drupal, once, drupalSettings) {
  /**
   * Intersection observer to observer elements.
   *
   * @param {object} el
   * The page element.
   */

  const init = function (el) {
    const speed = 20;
    const valueContainer = el.querySelector('.progress-bar__value');
    let progressValue = 0;

    // Convert to number
    const progressEndValue = Number(valueContainer.textContent);

    // Set initial wrapper/bg color
    el.style.backgroundColor = drupalSettings.bar_wrapper_color;

    // --- FIX: If value is 0, set the bar to 0 and stop animation ---
    if (progressEndValue === 0) {
      valueContainer.style.backgroundColor = drupalSettings.bar_val_color;
      valueContainer.textContent = '0%';
      valueContainer.style.width = '0%';

      valueContainer.style.minWidth = 'fit-content';
      valueContainer.style.paddingLeft = '5px';
      return;
    }

    // Otherwise animate normally
    const progress = setInterval(function () {
      progressValue += 1;

      valueContainer.style.backgroundColor = drupalSettings.bar_val_color;
      valueContainer.textContent = `${progressValue}%`;
      valueContainer.style.width = `${progressValue}%`;
      valueContainer.style.minWidth = 'fit-content';
      valueContainer.style.paddingLeft = '5px';

      // FIX: use >= to prevent infinite looping with float/string mismatch
      if (progressValue >= progressEndValue) {
        clearInterval(progress);
      }
    }, speed);
  };

  /**
   * Attaches the progressBar behavior to Progress Bar field.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the progress animation behavior for progress field.
   */
  Drupal.behaviors.progressBar = {
    attach(context) {
      once('animate', '.progress-bar__wrapper', context).forEach(init);
    },
  };
})(Drupal, once, drupalSettings);
