(function (Drupal, once, drupalSettings) {
  /**
   * Intersection observer to observer elements.
   *
   * @param {object} el
   *  The page element.
   */
  const init = function (el) {
    const speed = 20;
    const valueContainer = el.querySelector('.progress-circle__value');
    let progressValue = 0;

    // Convert text to number safely.
    const progressEndValue = Number(valueContainer.textContent);

    // --- FIX: If the end value is 0, stop animation immediately ---
    if (progressEndValue === 0) {
      valueContainer.textContent = '0%';
      el.style.background = `conic-gradient(
        ${drupalSettings.circle_wrapper_color} 0deg
      )`;
      return;
    }

    const progress = setInterval(function () {
      progressValue++;
      valueContainer.textContent = `${progressValue}%`;

      el.style.background = `conic-gradient(
        ${drupalSettings.circle_val_color} ${progressValue * 3.6}deg,
        ${drupalSettings.circle_wrapper_color} ${progressValue * 3.6}deg
      )`;

      if (progressValue >= progressEndValue) {
        clearInterval(progress);
      }
    }, speed);
  };

  /**
   * Attaches the progressCircle behavior to Progress Circle field.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the progress animation behavior for progress field.
   */
  Drupal.behaviors.progressCircle = {
    attach(context) {
      once('animate', '.progress-circle__wrapper', context).forEach(init);
    },
  };
})(Drupal, once, drupalSettings);
