module.exports = {
  parserOptions: {
    ecmaVersion: 2019,
    sourceType: 'module',
  },
  extends: ['airbnb-base', 'plugin:import/recommended'],
  root: true,
  env: {
    es6: true,
    browser: true,
  },
  plugins: ['svelte3'],
  overrides: [
    {
      files: ['*.svelte'],
      processor: 'svelte3/svelte3',
    },
  ],
  globals: {
    Drupal: true,
    drupalSettings: true,
    drupalTranslations: true,
    jQuery: true,
    _: true,
    Cookies: true,
    Backbone: true,
    Modernizr: true,
    loadjs: true,
    Popper: true,
    Shepherd: true,
    Sortable: true,
    once: true,
    CKEDITOR: true,
    CKEditor5: true,
    tabbable: true,
  },
  rules: {
    'consistent-return': ['off'],
    'no-underscore-dangle': ['off'],
    'max-nested-callbacks': ['warn', 3],
    'import/no-mutable-exports': ['off'],
    'import/no-extraneous-dependencies': ['off'],
    'import/first': ['off'],
    'no-plusplus': [
      'warn',
      {
        allowForLoopAfterthoughts: true,
      },
    ],
    'no-param-reassign': ['off'],
    'no-prototype-builtins': ['off'],
    'valid-jsdoc': [
      'warn',
      {
        prefer: {
          returns: 'return',
          property: 'prop',
        },
        requireReturn: false,
      },
    ],
    'no-unused-vars': ['warn'],
    'max-len': ['off'],
    // Rules to disable because Prettier is enforced. This would typically be
    // achieved by extending plugin/prettier/recommended, but this results in
    // conflicts that can be addressed by simply adding the rules manually
    // below:
    'array-bracket-newline': ['off'],
    'array-bracket-spacing': ['off'],
    'array-element-newline': ['off'],
    'arrow-parens': ['off'],
    'arrow-spacing': ['off'],
    'block-spacing': ['off'],
    'brace-style': ['off'],
    'comma-dangle': ['off'],
    'comma-spacing': ['off'],
    'comma-style': ['off'],
    'computed-property-spacing': ['off'],
    'dot-location': ['off'],
    'eol-last': ['off'],
    'func-call-spacing': ['off'],
    'function-call-argument-newline': ['off'],
    'function-paren-newline': ['off'],
    'generator-star': ['off'],
    'generator-star-spacing': ['off'],
    'implicit-arrow-linebreak': ['off'],
    indent: ['off'],
    'jsx-quotes': ['off'],
    'key-spacing': ['off'],
    'keyword-spacing': ['off'],
    'linebreak-style': ['off'],
    'multiline-ternary': ['off'],
    'newline-per-chained-call': ['off'],
    'new-parens': ['off'],
    'no-arrow-condition': ['off'],
    'no-comma-dangle': ['off'],
    'no-extra-parens': ['off'],
    'no-extra-semi': ['off'],
    'no-floating-decimal': ['off'],
    'no-mixed-spaces-and-tabs': ['off'],
    'no-multi-spaces': ['off'],
    'no-multiple-empty-lines': ['off'],
    'no-reserved-keys': ['off'],
    'no-space-before-semi': ['off'],
    'no-trailing-spaces': ['off'],
    'no-whitespace-before-property': ['off'],
    'no-wrap-func': ['off'],
    'nonblock-statement-body-position': ['off'],
    'object-curly-newline': ['off'],
    'object-curly-spacing': ['off'],
    'object-property-newline': ['off'],
    'one-var-declaration-per-line': ['off'],
    'operator-linebreak': ['off'],
    'padded-blocks': ['off'],
    'quote-props': ['off'],
    'rest-spread-spacing': ['off'],
    semi: ['off'],
    'semi-spacing': ['off'],
    'semi-style': ['off'],
    'space-after-function-name': ['off'],
    'space-after-keywords': ['off'],
    'space-before-blocks': ['off'],
    'space-before-function-paren': ['off'],
    'space-before-function-parentheses': ['off'],
    'space-before-keywords': ['off'],
    'space-in-brackets': ['off'],
    'space-in-parens': ['off'],
    'space-infix-ops': ['off'],
    'space-return-throw-case': ['off'],
    'space-unary-ops': ['off'],
    'space-unary-word-ops': ['off'],
    'switch-colon-spacing': ['off'],
    'template-curly-spacing': ['off'],
    'template-tag-spacing': ['off'],
    'unicode-bom': ['off'],
    'wrap-iife': ['off'],
    'wrap-regex': ['off'],
    'yield-star-spacing': ['off'],
    'standard/array-bracket-even-spacing': ['off'],
    'standard/computed-property-even-spacing': ['off'],
    'standard/object-curly-even-spacing': ['off'],
  },
};
