<?php

namespace Drupal\prometheus_metrics\Access;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessCheckInterface;
use Drupal\prometheus_metrics\EventSubscriber\PrometheusDefaults;
use Symfony\Component\Routing\Route;

/**
 * Checks access for displaying prometheus metrics.
 */
class MetricsAccessChecker implements AccessCheckInterface {

  /**
   * The config factory.
   *
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * Constructs a MetricsAccessChecker object.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $config_factory
   *   The config factory.
   */
  public function __construct(ConfigFactoryInterface $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public function applies(Route $route) {
    return NULL;
  }

  /**
   * A custom access check.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   Run access checks for this account.
   *
   * @return \Drupal\Core\Access\AccessResultInterface
   *   The access result.
   */
  public function access(AccountInterface $account) {
    $config = $this->configFactory->get(PrometheusDefaults::CONFIGURATION_NAME);
    $require_auth = $config->get('require_auth') ?? TRUE;

    if (!$require_auth) {
      return AccessResult::allowed()->setCacheMaxAge(0);
    }

    return AccessResult::allowedIfHasPermission($account, 'access prometheus metrics')
      ->setCacheMaxAge(0);
  }

}
