<?php

namespace Drupal\prometheus_metrics\EventSubscriber;

use Drupal\prometheus_metrics\Events\RebuildMetricsEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Base class for metrics rebuild subscribers.
 */
abstract class AbstractRebuildMetricsSubscriber implements EventSubscriberInterface, RebuildMetricsSubscriberInterface {

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      RebuildMetricsEvent::class => ['onRebuildMetrics'],
    ];
  }

  /**
   * Reacts to the metrics being rebuilt.
   */
  final public function onRebuildMetrics(RebuildMetricsEvent $event): void {
    $this->rebuildMetrics($event->getPrometheusMetrics());
  }

}
