<?php

namespace Drupal\prometheus_metrics\EventSubscriber;

use Drupal\prometheus_metrics\Bridge\PrometheusMetricsInterface;

/**
 * Contract for subscribers that rebuild metrics after a registry wipe.
 */
interface RebuildMetricsSubscriberInterface {

  /**
   * Rebuilds metrics when the Prometheus registry is reset.
   *
   * @param \Drupal\prometheus_metrics\Bridge\PrometheusMetricsInterface $metrics
   *   The metric registry to repopulate.
   *
   * @return void
   *   Returns void.
   */
  public function rebuildMetrics(PrometheusMetricsInterface $metrics): void;

}
