<?php

namespace Drupal\prometheus_metrics\Events;

use Drupal\prometheus_metrics\Bridge\PrometheusMetricsInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Stores details about the event.
 */
class RebuildMetricsEvent extends Event {
  /**
   * The prometheus metrics service.
   *
   * @var \Drupal\prometheus_metrics\Bridge\PrometheusMetricsInterface
   */
  private PrometheusMetricsInterface $prometheusMetrics;

  /**
   * Creates the event entity.
   *
   * @param \Drupal\prometheus_metrics\Bridge\PrometheusMetricsInterface $prometheusMetrics
   *   The prometheus metrics service.
   */
  public function __construct(PrometheusMetricsInterface $prometheusMetrics) {
    $this->prometheusMetrics = $prometheusMetrics;
  }

  /**
   * Returns the prometheus metrics service.
   *
   * @return \Drupal\prometheus_metrics\Bridge\PrometheusMetricsInterface
   *   The prometheus metrics service.
   */
  public function getPrometheusMetrics(): PrometheusMetricsInterface {
    return $this->prometheusMetrics;
  }

}
