<?php

namespace Drupal\prometheus_metrics\Hook;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\prometheus_metrics\Events\EntityCRUDEvent;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;
use Drupal\prometheus_metrics\EventSubscriber\PrometheusEntityCRUDSubscriber;

/**
 * Hooks into entity CRUD events to dispatch entity crud events for prometheus.
 */
class PrometheusEntityCRUDHook {

  public function __construct(
    protected EventDispatcherInterface $eventDispatcher,
  ) {
  }

  /**
 * Implements hook_entity_insert().
 */
  #[Hook('entity_insert')]
  public function insert(EntityInterface $entity): void {
    $this->dispatchEvent(PrometheusEntityCRUDSubscriber::PROMETHEUS_ENTITY_INSERT, $entity);
  }

  /**
 * Implements hook_entity_update().
 */
  #[Hook('entity_update')]
  public function update(EntityInterface $entity): void {
    $this->dispatchEvent(PrometheusEntityCRUDSubscriber::PROMETHEUS_ENTITY_UPDATE, $entity);
  }

  /**
 * Implements hook_entity_delete().
 */
  #[Hook('entity_delete')]
  public function delete(EntityInterface $entity): void {
    $this->dispatchEvent(PrometheusEntityCRUDSubscriber::PROMETHEUS_ENTITY_DELETE, $entity);
  }

  /**
   * Dispatches the entity crud event.
   */
  public function dispatchEvent(string $eventName, EntityInterface $entity): void {
    $event = new EntityCRUDEvent($entity);
    $this->eventDispatcher->dispatch($event, $eventName);
  }

}
