<?php

declare(strict_types=1);

namespace Drupal\prometheus_metrics;

/**
 * Interface for metrics that can be rebuilt from scratch.
 */
interface RebuildableMetricInterface {

  /**
   * Rebuilds the metric from scratch.
   *
   * This method should query the database/entities and reset all metric
   * values to reflect the current state of the system.
   */
  public function rebuild(): void;

}
