import { ProseMirrorModules } from './prosemirror-modules';
import { 
  proseMirrorPluginRegistry, 
  ProseMirrorNodePlugin, 
  ProseMirrorMarkPlugin, 
  ProseMirrorMenuExtension, 
  ProseMirrorPluginExtension 
} from './plugin-registry';
import type { ApplicationWrapper } from '../wrappers/interfaces';

export interface ProseMirrorExtensibilityAPI {
  /**
   * Access to all ProseMirror modules for avoiding version conflicts
   */
  modules: typeof ProseMirrorModules;

  /**
   * Register a new node type
   */
  registerNodePlugin(plugin: ProseMirrorNodePlugin): void;

  /**
   * Register a new mark type  
   */
  registerMarkPlugin(plugin: ProseMirrorMarkPlugin): void;

  /**
   * Register a menu extension
   */
  registerMenuExtension(extension: ProseMirrorMenuExtension): void;

  /**
   * Register a plugin extension
   */
  registerPluginExtension(extension: ProseMirrorPluginExtension): void;

  /**
   * Access to utility functions and interfaces
   */
  utils: {
    // Types are exported through TypeScript module system
  };
}

/**
 * Main API object that gets exposed globally
 */
export const ProseMirrorAPI: ProseMirrorExtensibilityAPI = {
  modules: ProseMirrorModules,
  
  registerNodePlugin(plugin: ProseMirrorNodePlugin): void {
    proseMirrorPluginRegistry.registerNodePlugin(plugin);
  },

  registerMarkPlugin(plugin: ProseMirrorMarkPlugin): void {
    proseMirrorPluginRegistry.registerMarkPlugin(plugin);
  },

  registerMenuExtension(extension: ProseMirrorMenuExtension): void {
    proseMirrorPluginRegistry.registerMenuExtension(extension);
  },

  registerPluginExtension(extension: ProseMirrorPluginExtension): void {
    proseMirrorPluginRegistry.registerPluginExtension(extension);
  },

  utils: {
    // Types are exported through TypeScript module system
  },
};

// Export the registry for internal use
export { proseMirrorPluginRegistry }; 