// Export all ProseMirror modules for use by other modules
// This avoids versioning issues and provides a stable API

import * as prosemirrorCommands from 'prosemirror-commands';
import * as prosemirrorDropcursor from 'prosemirror-dropcursor';
import * as prosemirrorGapcursor from 'prosemirror-gapcursor';
import * as prosemirrorHistory from 'prosemirror-history';
import * as prosemirrorInputrules from 'prosemirror-inputrules';
import * as prosemirrorKeymap from 'prosemirror-keymap';
import * as prosemirrorMenu from 'prosemirror-menu';
import * as prosemirrorModel from 'prosemirror-model';
import * as prosemirrorSchemaBasic from 'prosemirror-schema-basic';
import * as prosemirrorSchemaList from 'prosemirror-schema-list';
import * as prosemirrorSearch from 'prosemirror-search';
import * as prosemirrorState from 'prosemirror-state';
import * as prosemirrorTables from 'prosemirror-tables';
import * as prosemirrorView from 'prosemirror-view';

export const ProseMirrorModules = {
  'prosemirror-commands': prosemirrorCommands,
  'prosemirror-dropcursor': prosemirrorDropcursor,
  'prosemirror-gapcursor': prosemirrorGapcursor,
  'prosemirror-history': prosemirrorHistory,
  'prosemirror-inputrules': prosemirrorInputrules,
  'prosemirror-keymap': prosemirrorKeymap,
  'prosemirror-menu': prosemirrorMenu,
  'prosemirror-model': prosemirrorModel,
  'prosemirror-schema-basic': prosemirrorSchemaBasic,
  'prosemirror-schema-list': prosemirrorSchemaList,
  'prosemirror-search': prosemirrorSearch,
  'prosemirror-state': prosemirrorState,
  'prosemirror-tables': prosemirrorTables,
  'prosemirror-view': prosemirrorView,
};

// Also export individual modules for direct imports
export {
  prosemirrorCommands,
  prosemirrorDropcursor,
  prosemirrorGapcursor,
  prosemirrorHistory,
  prosemirrorInputrules,
  prosemirrorKeymap,
  prosemirrorMenu,
  prosemirrorModel,
  prosemirrorSchemaBasic,
  prosemirrorSchemaList,
  prosemirrorSearch,
  prosemirrorState,
  prosemirrorTables,
  prosemirrorView,
}; 