import { createLeafBlock } from '../core/leaf-block';
import { ComponentDefinition } from '../wrappers/config';
import { ApplicationWrapper } from '../wrappers/interfaces';

export const codeBlockTemplate = (appWrapper: ApplicationWrapper) => (spec: any): ComponentDefinition => {
  return createLeafBlock({
    name: 'code_block',
    displayName: 'Code',
    group: 'block leaf_block',
    classes: ['code-block'],
    content: 'text*',
    editable: true,
    disableFormatting: true,
    whitespace: 'pre',
    marks: '',
    defining: true,
    isolating: true,
    createContentDOM: (container: HTMLElement) => {
      const pre = document.createElement('pre');
      const code = document.createElement('code');
      pre.appendChild(code);
      container.appendChild(pre);
      return code;
    },
    variants: {
      shell: 'Shell',
      typescript: 'TypeScript',
      graphql: 'GraphQL',
      json: 'JSON',
    },
    ...spec
  }, appWrapper);
};

export const createCodeBlockComponents = (appWrapper: ApplicationWrapper) => codeBlockTemplate(appWrapper);
