import { TooltipConfig, RenderResult } from '../interfaces';

/**
 * DOMTooltipRenderer is a renderer for the tooltip component.
 *
 * @todo: Move styles to a separate file.
 */
export class DOMTooltipRenderer {
  create(config: TooltipConfig): RenderResult<HTMLElement> {
    const tooltip = document.createElement('div');
    tooltip.className = config.className || 'tooltip';
    
    // Set content
    if (typeof config.content === 'string') {
      tooltip.textContent = config.content;
    } else {
      tooltip.appendChild(config.content);
    }
    
    // Set position if provided
    if (config.position) {
      tooltip.style.left = `${config.position.x}px`;
      tooltip.style.top = `${config.position.y}px`;
    }
    
    // Add to document
    document.body.appendChild(tooltip);
    
    // Handle non-interactive tooltips
    if (!config.interactive) {
      tooltip.style.pointerEvents = 'none';
    }
    
    return {
      element: tooltip,
      destroy: () => {
        tooltip.remove();
      },
      update: (newConfig: Partial<TooltipConfig>) => {
        if (newConfig.content !== undefined) {
          tooltip.innerText = '';
          if (typeof newConfig.content === 'string') {
            tooltip.textContent = newConfig.content;
          } else {
            tooltip.appendChild(newConfig.content);
          }
        }
        
        if (newConfig.position) {
          tooltip.style.left = `${newConfig.position.x}px`;
          tooltip.style.top = `${newConfig.position.y}px`;
        }
        
        if (newConfig.className !== undefined) {
          tooltip.className = newConfig.className;
        }
      }
    };
  }
} 