import { MenuElement, MenuItem } from "prosemirror-menu";
import { EntitySelectorPluginSettings } from "../plugins/entity-selector";
import { Node, NodeSpec, Schema } from "prosemirror-model";
import { Plugin } from "prosemirror-state";
import { ApplicationWrapper } from "./interfaces";

export interface ComponentDefinition {
    spec: NodeSpec;
    plugin: Plugin;
    name: string;
    menuName?: 'insert';
    menuItem: (schema: Schema) => MenuItem;
  }
  
  export type ProsemirrorComponentTemplateTypes = Record<string, (spec: any, appWrapper: ApplicationWrapper) => ComponentDefinition>;
  export type ProsemirrorComponent = {
    type: string;
    options: Record<string, any> & { name: string };
  };
  
  export interface ProsemirrorSettings {
  templateTypes: ProsemirrorComponentTemplateTypes;
  components: ProsemirrorComponent[];

  /// System nodes configuration (doc, text, etc.)
  systemNodes?: {
    doc?: { content: string };
    text?: { group: string };
    defaultElement?: string;
    media?: any;
    code_block?: {
      enabled?: boolean;
      languages?: Record<string, string>;
    };
    table?: {
      enabled?: boolean;
      max_rows?: number;
      max_columns?: number;
      allow_header_rows?: boolean;
    };
    bullet_list?: { enabled?: boolean };
    ordered_list?: { enabled?: boolean };
    heading?: {
      enabled?: boolean;
      levels?: number[];
    };
    [key: string]: any;
  };

  /// Marks configuration from Drupal
  marks?: {
    [key: string]: {
      enabled?: boolean;
      parse_dom?: Array<any>;
      to_dom?: any;
      attributes?: any;
      variants?: Record<string, string>;
    };
  };

  /// The schema to generate key bindings and menu items for.
  schema?: Schema;
  
    /// Can be used to [adjust](#example-setup.buildKeymap) the key bindings created.
    mapKeys?: {[key: string]: string | false};
  
    /// Set to false to disable the history plugin.
    history?: boolean;
  
    /// Set to false to make the menu bar non-floating.
    floatingMenu?: boolean;
  
    /// Enable search/replace features
    search?: boolean;
  
    /// Can be used to override the menu content.
    menuContent?: MenuElement[][];
  
    /// Media plugin settings
    media?: {
      drupalMedia: {
        libraryURL: string;
        metadataUrl: string;
        previewURL: string;
        previewCsrfToken: string;
        openDialog?: (url: string, saveCallback: (data: any) => void, dialogSettings: any) => void;
        dialogSettings?: Record<string, any>;
      };
    };
  
    /// Entity selector plugin settings
    entitySelector?: EntitySelectorPluginSettings;
  
    /// Callback to be called when the editor content changes
    onChange?: (doc: Node) => void;
  }
