# ProseMirror Examples Module

This module provides default element and mark configurations for the ProseMirror editor.

## Node Type Mapping

The transformation between ProseMirror and structured formats follows a simple rule:
- **ProseMirror → Structured**: Convert underscores (`_`) to dashes (`-`)
- **Structured → ProseMirror**: Convert dashes (`-`) to underscores (`_`)

### Examples

| ProseMirror Type | Structured Type |
|------------------|-----------------|
| `paragraph` | `paragraph` |
| `heading` (with level) | `heading-1`, `heading-2`, etc. |
| `bullet_list` | `bullet-list` |
| `ordered_list` | `ordered-list` |
| `list_item` | `list-item` |
| `horizontal_rule` | `horizontal-rule` |
| `drupal_media` | `media` (special case) |

## What's Included

### Elements

- **Document (`doc`)**: The root element
- **Text (`text`)**: Text nodes
- **Paragraph (`paragraph`)**: Basic text blocks
- **Heading (`heading`)**: Headers with level attribute (1-6)
- **Lists (`bullet_list`, `ordered_list`)**: Unordered and ordered lists
- **List Item (`list_item`)**: Items within lists
- **Blockquote (`blockquote`)**: Quote blocks
- **Horizontal Rule (`horizontal_rule`)**: Divider lines
- **Media (`drupal_media`)**: Embedded media (transforms to `media`)

### Marks

- **Bold (`strong`)**: Bold text
- **Italic (`em`)**: Italicized text

## Element Configuration

Elements specify:
- `is_top_level_block`: Whether this can be a direct child of the document
- `is_list_item_block`: Whether this can appear inside list items

### Example Element Configuration

```yaml
id: paragraph
label: Paragraph
machine_name: paragraph
type: base_node
groups:
  - block
options:
  is_top_level_block: true
  is_list_item_block: true
```

## Extending

To add your own element types:

1. Create a new `.yml` file in your module's `config/install` directory
2. Use the machine name with underscores (e.g., `my_custom_block`)
3. The structured type will automatically be `my-custom-block`
4. Set the block classification flags as needed

The transformation system automatically handles the underscore-to-dash conversion. 