<?php

namespace Drupal\prosemirror\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * Defines a ProseMirror Extension plugin annotation object.
 *
 * @Annotation
 */
class ProseMirrorExtension extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the extension.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A brief description of the extension.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The weight of the extension (for loading order).
   *
   * @var int
   */
  public $weight = 0;

  /**
   * The libraries this extension requires for CSS and JavaScript.
   *
   * @var array
   */
  public $libraries = [];

}
