<?php

namespace Drupal\prosemirror\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a ProseMirror rendering plugin annotation object.
 *
 * @see \Drupal\prosemirror\Rendering\Plugin\ProseMirrorRenderingPluginManager
 * @see plugin_api
 *
 * @Annotation
 */
class ProseMirrorRenderingPlugin extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the rendering plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * A short description of the rendering plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $description;

  /**
   * The node types this plugin can render.
   *
   * @var array
   */
  public $node_types = [];

  /**
   * The supported output formats like 'html', 'plain_text', 'markdown'.
   *
   * @var array
   */
  public $formats = ['html'];

  /**
   * The plugin weight (lower values run first).
   *
   * @var int
   */
  public $weight = 0;

}
